/**************************************************************************************
 
   Copyright (c) Hilscher GmbH. All Rights Reserved.
 
 **************************************************************************************
 
   Filename:
    $Workfile: ProfibusApm_Functionlist.h $
   Last Modification:
    @version $Id: ProfibusApm_Functionlist.h 37501 2013-08-19 14:13:06Z Eric $
   
   Targets:
    Win32/ANSI   : no
    Win32/Unicode: no (define _UNICODE)
    WinCE        : yes
    rcX          : yes
 
   Description:
     
    Profibus Apm
    Task function list for configuration file
       
   Changes:
 
     Version    Date        Author
        Description
     ----------------------------------------------------------------------------------
        
**************************************************************************************/
#ifndef __PROFIBUS_APM_FUNCTIONLIST_H
#define __PROFIBUS_APM_FUNCTIONLIST_H

#include "rX_Includes.h"                        /* Standard Includes                */

/***************************************************************************************/
/* Profibus Apm startup parameter */
#define PROFIBUS_APM_PARAMETER_VERSION_V2    2

#define PROFIBUS_APM_IO_MODE_DISABLE                0x00000000L
#define PROFIBUS_APM_IO_MODE_PIO                    0x00000001L
#define PROFIBUS_APM_IO_MODE_GPIO                   0x00000002L

typedef struct PROFIBUS_APM_IO_CONFIG_Ttag  PROFIBUS_APM_IO_CONFIG_T;

struct PROFIBUS_APM_IO_CONFIG_Ttag
{
  TLR_UINT32    ulMode;         /* IO mode    */
  TLR_UINT32    ulPinNumber;    /* Pin number */
  TLR_BOOLEAN32 fInverted;      /* Inverted   */
};

typedef struct PROFIBUS_APM_PARAMETER_Ttag {
  struct
  {
    TLR_UINT32 ulTaskIdentifier; /* task identifier see TLR_TaskIdentifier.h*/
    TLR_UINT32 ulParamVersion;   /* structure version  */
  }tPrmHeader;

  TLR_UINT16                  usVendorId;      /* PROFIBUS Vendor ID                  */
  TLR_UINT16                  usIdentNumber;   /* PROFIBUS Ident number               */
  TLR_UINT32                  ulDPMChannel;    /* Channel of DPM                      */
  PROFIBUS_APM_IO_CONFIG_T    tIoReady;        /* Ready IO Pin                        */
  PROFIBUS_APM_IO_CONFIG_T    tIoBusOn;        /* BusOn IO Pin                        */

} PROFIBUS_APM_PARAMETER_T;


/***************************************************************************************/
/* Profibus Apm function list, prototyes */

TLR_RESULT  TaskExit_ProfibusApm (TLR_VOID FAR* pvRsc);
TLR_RESULT  TaskLeave_ProfibusApm(TLR_VOID FAR* pvRsc, TLR_VOID FAR* pvLve);                                             
TLR_RESULT  TaskEnter_ProfibusApm(TLR_VOID FAR* pvInit);



/***************************************************************************************/
#endif /* #ifndef __PROFIBUS_APM_FUNCTIONLIST_H */
